/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS,
 * EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY
 * OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. TI DISCLAIMS
 * ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND NON-INFRINGEMENT
 * OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
 * YOUR USE OF THE PROGRAM.
 * IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR
 * INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR
 * NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY
 * OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.  EXCLUDED
 * DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION,
 * COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF
 * SAVINGS, OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
 * AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE
 * PROGRAM EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
 * Unless otherwise stated, the Program written and copyrighted by Texas
 * Instruments is distributed as "freeware".  You may, only under TI's copyright
 * in the Program, use and modify the Program without any charge or restriction.
 * You may distribute to third parties, provided that you transfer a copy of this
 * license to the third party and the third party agrees to these terms by its
 * first use of the Program. You must reproduce the copyright notice and any
 * other legend of ownership on each copy or partial copy, of the Program.
 * You acknowledge and agree that the Program contains copyrighted material,
 * trade secrets and other TI proprietary information and is protected by
 * copyright laws, international copyright treaties, and trade secret laws, as
 * well as other intellectual property laws.  To protect TI's rights in the
 * Program, you agree not to decompile, reverse engineer, disassemble or
 * otherwise translate any object code versions of the Program to a
 * human-readable form.  You agree that in no event will you alter, remove or
 * destroy any copyright notice included in the Program.  TI reserves all rights
 * not specifically granted under this license. Except as specifically provided
 * herein, nothing in this agreement shall be construed as conferring by
 * implication, estoppel, or otherwise, upon you, any license or other right
 * under any TI patents, copyrights or trade secrets.
 * You may not use the Program in non-TI devices. */


//******************************************************************************
//
//  i2c.h
//  Functions for using the I2C interface and ADS1015
//
//  Matthias Ulmann, Design Services - EMEA Power Management
//  Texas Instruments, Inc.
//
//******************************************************************************


#ifndef I2C_H
#define I2C_H


// bits for SCL and SDA (I2C)
#define SCL_BIT			BIT2
#define SDA_BIT			BIT1

// function select register for SCL and SDA
#define SCL_PSEL		P3SEL
#define SDA_PSEL		P3SEL

// direction register for SCL and SDA
#define SCL_PDIR		P3DIR
#define SDA_PDIR		P3DIR

// output register for SCL and SDA
#define SCL_POUT		P3OUT
#define SDA_POUT		P3OUT

// input register for SCL and SDA
#define SCL_PIN			P3IN
#define SDA_PIN			P3IN

// pullup/-down resistor register for SCL and SDA
#define SCL_RES			P3REN
#define SDA_RES			P3REN


#define SLAVE_ADDRESS	0x48		// ADS1015


// global variables to store the mains and the pfc voltage
extern volatile unsigned int voltage_mains, voltage_pfc;

// global variable to select the channel on ADS1015
extern volatile unsigned int I2C_channel;

// variable to control the I2C communication
extern volatile unsigned int I2C_flow;


// This function manages the whole I2C communication 
extern void i2c_communication(void);

// Conversion of the sampled digital value into voltage.
// The value has three digits without decimal place.
extern unsigned int lsb_to_voltage_i2c(unsigned int lsb);

// global variable to store the output current
extern volatile unsigned int current_output;

// Initialization of the I2C interface
extern void init_i2c(void);

// Send configuration to ADS1015
// 0: PFC, 1: mains
void ic2_send_configuration(unsigned int channel);

// Select conversion register of ADS1015 for reading
extern void ic2_select_conversion_register(void);

// Read conversion register of ADS1015
extern void i2c_read_conversion_register(void);



#endif /*I2C_H*/
